/* sccsid[] = "@(#) $Id: //bas/46D/src/include/crfcfunc.h#3 $ SAP" */   
//

// SAP RFC C++ Class library.
// Copyright (C) 1996 SAP America, Inc.
// All rights reserved.
                        

////////////////////////////////////////////////////////////////////////////////
//  File crfcfunc.h
// 
//  Declarations for CRfcFunction
////////////////////////////////////////////////////////////////////////////////

#ifndef CRFCFUNC__H
#define CRFCFUNC__H

#include "crfcglob.h"
#include "crfcstrn.h"
#include "crfcimex.h"
#include "crfctabl.h"
#include "crfclist.h"


#ifdef _WIN32
#include <tchar.h>

#define CRFCFUNC_CONSTRUCTOR \
            _T("CRfcFunction::CRfcFunction(const CRfcConnection*...) called")
#define CRFCFUNC_DESTRUCTOR \
            _T("CRfcFunction::~CRfcFunction(void) called")
#define CRFCFUNC_SETCONNECTION \
            _T("CRfcFunction::SetConnection called")
#define CRFCFUNC_GETCONNECTION \
            _T("CRfcFunction::GetConnection called")
#define CRFCFUNC_SETFUNCTIONNAME \
            _T("CRfcFunction::SetFunctionName called")
#define CRFCFUNC_GETFUNCTIONNAME \
            _T("CRfcFunction::GetFunctionName called")
#define CRFCFUNC_ADDIMPORTPARAM \
            _T("CRfcFunction::AddImportParam called")
#define CRFCFUNC_ADDEXPORTPARAM \
            _T("CRfcFunction::AddExportParam called")
#define CRFCFUNC_ADDTABLEPARAM \
            _T("CRfcFunction::AddTableParam called")
#define CRFCFUNC_GETIMPORTPARAM_INT \
            _T("CRfcFunction::GetImportParam(int) called")
#define CRFCFUNC_GETIMPORTPARAM_CSTR \
            _T("CRfcFunction::GetImportParam(CSTR) called")
#define CRFCFUNC_GETEXPORTPARAM_INT \
            _T("CRfcFunction::GetExportParam(int) called")
#define CRFCFUNC_GETEXPORTPARAM_CSTR \
            _T("CRfcFunction::GetExportParam(CSTR) called")
#define CRFCFUNC_GETTABLEPARAM_INT \
            _T("CRfcFunction::GetTableParam(int) called")
#define CRFCFUNC_GETTABLEPARAM_CSTR \
            _T("CRfcFunction::GetTableParam(CSTR) called")
#define CRFCFUNC_LISTEN \
            _T("CRfcFunction::Listen called")
#define CRFCFUNC_GETNAMEFORLIST \
            _T("CRfcFunction::GetNameForList called")
#define CRFCFUNC_SETUPIMPORTS \
            _T("CRfcFunction::SetUpImports called")
#define CRFCFUNC_SETUPEXPORTS \
            _T("CRfcFunction::SetUpExports called")
#define CRFCFUNC_SETUPTABLES \
            _T("CRfcFunction::SetUpTables called")
#define CRFCFUNC_EXTRACTTABLES\
            _T("CRfcFunction::ExtractTables called")
#define CRFCFUNC_CONVERTEXPORTS \
            _T("CRfcFunction::ConvertExports called")
#define CRFCFUNC_GETIMPORTCOUNT \
			_T("CRfcFunction::GetImportCount() called")
#define CRFCFUNC_GETEXPORTCOUNT \
			_T("CRfcFunction::GetExportCount() called")
#define CRFCFUNC_GETTABLECOUNT \
			_T("CRfcFunction::GetTableCount() called")
#define CRFCFUNC_CHECKTABLES \
            _T("CRfcClientFunc::CheckTables called")
#define CRFCFUNC_CHECKTAB_NULL_TAB_HANDLE \
			_T("Null internal table handle in CRfcFunction::CheckTables")
#else

#define CRFCFUNC_CONSTRUCTOR \
            "CRfcFunction::CRfcFunction(const CRfcConnection*...) called"
#define CRFCFUNC_DESTRUCTOR \
            "CRfcFunction::~CRfcFunction(void) called"
#define CRFCFUNC_SETCONNECTION \
            "CRfcFunction::SetConnection called"
#define CRFCFUNC_GETCONNECTION \
            "CRfcFunction::GetConnection called"
#define CRFCFUNC_SETFUNCTIONNAME \
            "CRfcFunction::SetFunctionName called"
#define CRFCFUNC_GETFUNCTIONNAME \
            "CRfcFunction::GetFunctionName called"
#define CRFCFUNC_ADDIMPORTPARAM \
            "CRfcFunction::AddImportParam called"
#define CRFCFUNC_ADDEXPORTPARAM \
            "CRfcFunction::AddExportParam called"
#define CRFCFUNC_ADDTABLEPARAM \
            "CRfcFunction::AddTableParam called"
#define CRFCFUNC_GETIMPORTPARAM_INT \
            "CRfcFunction::GetImportParam(int) called"
#define CRFCFUNC_GETIMPORTPARAM_CSTR \
            "CRfcFunction::GetImportParam(CSTR) called"
#define CRFCFUNC_GETEXPORTPARAM_INT \
            "CRfcFunction::GetExportParam(int) called"
#define CRFCFUNC_GETEXPORTPARAM_CSTR \
            "CRfcFunction::GetExportParam(CSTR) called"
#define CRFCFUNC_GETTABLEPARAM_INT \
            "CRfcFunction::GetTableParam(int) called"
#define CRFCFUNC_GETTABLEPARAM_CSTR \
            "CRfcFunction::GetTableParam(CSTR) called"
#define CRFCFUNC_LISTEN \
            "CRfcFunction::Listen called"
#define CRFCFUNC_GETNAMEFORLIST \
            "CRfcFunction::GetNameForList called"
#define CRFCFUNC_SETUPIMPORTS \
            "CRfcFunction::SetUpImports called"
#define CRFCFUNC_SETUPEXPORTS \
            "CRfcFunction::SetUpExports called"
#define CRFCFUNC_SETUPTABLES \
            "CRfcFunction::SetUpTables called"
#define CRFCFUNC_EXTRACTTABLES\
            "CRfcFunction::ExtractTables called"
#define CRFCFUNC_CONVERTEXPORTS \
            "CRfcFunction::ConvertExports called"
// NETDYNAMICS
#define CRFCFUNC_GETIMPORTCOUNT \
			"CRfcFunction::GetImportCount() called"
#define CRFCFUNC_GETEXPORTCOUNT \
			"CRfcFunction::GetExportCount() called"
#define CRFCFUNC_GETTABLECOUNT \
			"CRfcFunction::GetTableCount() called"
// NETDYNAMICS
#define CRFCFUNC_CHECKTABLES \
            "CRfcClientFunc::CheckTables called"
#define CRFCFUNC_CHECKTAB_NULL_TAB_HANDLE \
			"Null internal table handle in CRfcFunction::CheckTables"
#endif

extern CRfcTrace RfcClassTrace;


#define  FUNCTIONNAME_LEN  30

////////////////////////////////////////////////////////////////////////////////
// CRfcFunction class declaration 

class CRfcFunction
{



    // Attributes
public:
    // Application transaction ID, supported only in R/3 3.0b 
    // system and above. 
    static RFC_TID   rfcTID ;
    
  // operations
    // Assign an RFC connection object to the RFC function object
    // The connection object needs to be set only once for all 
    // subsequent calls to the RFC function if no connection object
    // change is needed. 
    void                   SetConnection (const CRfcConnection& connection)  { m_pConnection = &connection; }
    const  CRfcConnection& GetConnection (void) const { return *m_pConnection; }

    // Retrieve and set function name
    CSTR    GetFunctionName (void) const { return CSTR(m_rstrFuncName); } 
    // Throws const char* for memory exceptions.
    void    SetFunctionName (CSTR name);
		//only allow SetFuncName on function with empty names
    

    // Setup Import, Export and Table parameters.
    // All added parameters must not associate with another RFC function object.
    // Throws const char* for memory exceptions.
    void    AddImportParam  (CRfcImpExpParam& param);
    // Throws const char* for memory exceptions.
    void    AddExportParam  (CRfcImpExpParam& param);
    // Throws const char* for memory exceptions.
    void    AddTableParam   (CRfcTableParam&  table);

//  Remove parameter object

	BOOL RemoveImportParam (CSTR strParamName);  //  Given name of parameter
	BOOL RemoveExportParam (CSTR strParamName);  //  Given name of parameter
	BOOL RemoveTableParam (CSTR strParamName);  //  Given name of parameter


	BOOL RemoveImportParam (int  nIndex);  //  Given index of parameter
	BOOL RemoveExportParam (int  nIndex);  //  Given index of parameter
	BOOL RemoveTableParam (int  nIndex);  //  Given index of parameter


//  Replace old parameter object with new one.  Return a pointer to the old new
	
	BOOL ReplaceImportParam (CRfcImpExpParam * newParam);  //  Given name of old parameter
	BOOL ReplaceExportParam (CRfcImpExpParam * newParam);  //  Given name of old parameter
	BOOL ReplaceTableParam (CRfcTableParam * newParam);  //  Given name of old parameter


    // Retrieve Import parameter  
    CRfcImpExpParam*	GetImportParam (int  nIndex) { return m_Imports[nIndex]; }
    CRfcImpExpParam*	GetImportParam (CSTR strParamName) { return m_Imports[strParamName]; }

    // Retrieve Export parameter
    CRfcImpExpParam*    GetExportParam (int  nIndex) { return m_Exports[nIndex]; }
    CRfcImpExpParam*    GetExportParam (CSTR strParamName) { return m_Exports[strParamName]; }

    // Retrieve table parameter
    CRfcTableParam*     GetTableParam  (int nIndex) { return m_Tables[nIndex]; }
    CRfcTableParam*     GetTableParam  (CSTR strTableName) { return m_Tables[strTableName]; }

    // Chheck if there is an RFC request available
    RFC_RC              Listen (void);

// NETDYNAMICS
	unsigned			GetImportCount	(void) const { return m_Imports.GetSize(); }
	unsigned			GetExportCount	(void) const { return m_Exports.GetSize(); }
	unsigned			GetTableCount	(void) const { return m_Tables.GetSize(); }
// NETDYNAMICS

	RFC_HANDLE GetConnectionRfcHandle(void) const;

//  These two functions are for adding external programs for the RFC library explicitly to
//  start.  The first function will add a program.  The second one will start the programs
//  added by the first one(if the argument is NULL) or the program names in the arguments
//  of the second program.
 
	void AddProgram(char *program_name);
	void AllowStartPrograms(char *program_names=NULL);

//implementation
    CSTR                GetNameForList(void) const { return GetFunctionName(); }
	                                                 // Wrapper function for list
                                                    // to do search by name
protected:
    CRfcList<CRfcImpExpParam>   m_Exports;      // Export parameters;
    CRfcList<CRfcImpExpParam>   m_Imports;      // Import parameters;
    CRfcList<CRfcTableParam>    m_Tables;       // Table parameters
    CRfcString                  m_rstrFuncName; // Remote function name;
    const CRfcConnection*       m_pConnection;  // Reference to a connection

	CRfcString m_ProgramNames;		   //	List of the program names(separated by ;) that the RFC
										//  client or server application wants the RFC library automatically to start.                                            // object

    RFC_PARAMETER  *m_pImpStructs;   //RFC import parameter structure 
    RFC_PARAMETER  *m_pExpStructs;   //RFC export parameter structure 
    RFC_TABLE      *m_pTabStructs;   //RFC table  parameter structure 
    //Flags to indicate if the above pointers point
    //to adequete memory for imports, exports, tables
    BOOL m_bImportsInvalid, 
         m_bExportsInvalid, 
         m_bTablesInvalid; 
	
// Constructor & destructor. They are made protected because this class 
// is not to be used directly. Use CRfcClientFunc or CRfcServerFunc instead

    // Constructor throws const char* for memory exceptions.

	CRfcFunction (const CRfcConnection* pConnection=NULL, CSTR strFuncName=NULL);
    virtual ~CRfcFunction(void)=0;


    // Allocate mem for pImpStructs and fill in contents
    // Throws const char* for memory exceptions.
    void SetUpImports(BOOL bPassAllParams=FALSE);
    // Allocate mem for pExpStructs and fill in contents
    // Throws const char* for memory exceptions.
    void SetUpExports(void);
    // Allocate mem for pTabStructs and fill in contents
    // Throws const char* for memory exceptions.
    void SetUpTables(void);
    
    // Store returned table handles into table objects
    void ExtractTables(void);
    // Do data conversion on exported data
    void ConvertExports(void); 

    // Disallow copy and assignment between function objects for now
	CRfcFunction (const CRfcFunction& sourceFunc); 
    CRfcFunction& operator= (const CRfcFunction& sourceFunc );
	void CopyCRfcFunction(const CRfcFunction& sourceFunc);
	void FreeCRfcFunction(void);
    void CheckTables(void) const; //check to make sure all tables
                                  //provided valid internal table handles
private: 
	void AllowStartProgramsWithSeparator(CRfcString & program_names);
};                                            

#endif          //CRFCFUNC__H
